/*== TTi TGA1240 40Ms/s Arbitrary Generator ======================*/

/*== GLOBAL CONSTANT DECLARATIONS =========================================*/

/* Replace 10 with the maximum number of devices of this type being used.  */
#define tga1240_MAX_INSTR        10

/*== GLOBAL FUNCTION DECLARATIONS =========================================*/
int __stdcall tga1240_init (int, int, int, int*);
int __stdcall tga1240_config_wfm (int instrumentID, int functtion,
                                double freqquencyPeriodHz, double amplitudeVpp,
                                double DCOffsetV, int sense, int load,
                                int output, char arbwfmname[], int freqPer, int chan);
int __stdcall tga1240_config_pulse (int instrumentID, int channel,
                                  double pulsePeriod, double pulseWidth,
                                  double pulseDelay);
int __stdcall tga1240_config_pulse_trn (int instrumentID, int channel,
                                      int pulseNumber, double pulseTrainPeriod,
                                      double baseline, double pulseLevel,
                                      double pulseWidth, double pulseDelay,
                                      int Number_of_pulses, int Make);
int __stdcall tga1240_arb_info (int instrumentID, char newarbname[], int *length);
int __stdcall tga1240_arb_create (int instrumentID, char arbName[], int create,
                                int length, int waveformtocopy,
                                char arbitraryname[]);
int __stdcall tga1240_arb_modify (int instrumentID, char arbname[], int operation,
                                int newlength, char newarbname[]);
int __stdcall tga1240_arb_edit (int instrumentID, char arbname[], int operation,
                              int firstpointidx, int firstpointvalue,
                              int secondpointidx, int secondpointvalue,
                              int destinationidx, float amplitudemultiplier,
                              int offsetvalue, int waveformtoinsert, char insertarb[]);
int __stdcall tga1240_setup_mode (int instrumentID, int channel, int mode,
                                int triggersource, double internalperiod,
                                int burstcount, int triggerslope,
                                float phaseangle);
int __stdcall tga1240_setup_conector (int instrumentID, int channel, int output,
                                    int syncout, int syncoutsignal,
                                    int outputfilter, int triggerout, int hold);
int __stdcall tga1240_setup_sweep (int instrumentID, int channel, int sweeptype,
                                 int direction, int spacing,
                                 float startfrequency, float stopfrequency,
                                 int sync, float duration, float markerfrequency,
                                 int control);
int __stdcall tga1240_setup_seq (int instrumentID, int channel, int segmentno,
                               char arbwfmname[], int status, int count,
                               int stepon);
int __stdcall tga1240_setup_tone (int instrumentID, int channel, int tonenumber,
                                float tonefrequency, int tonetype);
int __stdcall tga1240_setup_mod (int instrumentID, int channel, int source,
                               int type, float SCMlevel, float AMdepth);
int __stdcall tga1240_setup_sum (int instrumentID, int channel, int source, 
                               float ratio, int atten);
int __stdcall tga1240_set_inter (int instrumentID, int channel, int mode,
                               float phaseangle, int status);
int __stdcall tga1240_arb_read (int instrumentID, char arbwfmname[], int start,
                              int end, short wfmdata[]);
int __stdcall tga1240_arb_write (int instrumentID, char arbwfmname[], int start,
                               int end, short wfmdata[]);




int __stdcall tga1240_send_trg (int instrumentID);








int __stdcall tga1240_set_status (int instrumentID, int setStatusEnable, int value);
int __stdcall tga1240_loc_stores (int, int, int );
int __stdcall tga1240_get_status (int, int, int* );
int __stdcall tga1240_snd_cmd (int, char*);
int __stdcall tga1240_get_resp (int, char* ,int *);
int __stdcall tga1240_file_ops (int, int, char* );
int __stdcall tga1240_new_arb (int, char*);
int __stdcall tga1240_arb_stores (int, int, int, char*);
int __stdcall tga1240_close (int);
/*=============================== END =====================================*/

